// Script assets have changed for v2.3.0 see
// https://help.yoyogames.com/hc/en-us/articles/360005277377 for more information
function scr_orbital_movement(){
	
	mass[0] = star_mass_modificator*star_mass;
	mass[1] = planet_mass_modificator*planet_mass;
	
	for(var iter = 0; iter < 2; iter += 1){
		
		for(var ii = 0; ii < Nobj; ii += 1){
			obj_hspeed[ii] += h_acc[ii] * 0.5 * dt;
			obj_vspeed[ii] += v_acc[ii] * 0.5 * dt;
			
			//if ( ii == 0){
			//	obj_hspeed[0] = 0;
			//	obj_vspeed[0] = 0;
			//}
		
			if ( obj_drag_action[ii] == 1){
				x_pos[ii] = scr_pixel2xpos(mouse_x);
				y_pos[ii] = scr_pixel2ypos(mouse_y);
			}
			else{
				x_pos[ii] += obj_hspeed[ii] * dt;
				y_pos[ii] += obj_vspeed[ii] * dt;				
			}
		}
	
		getAcc();
	
		for(var iii = 0; iii < Nobj; iii += 1){
			obj_hspeed[iii] += h_acc[iii] * 0.5 * dt;
			obj_vspeed[iii] += v_acc[iii] * 0.5 * dt;
		}
		
		obj_hspeed[0] = 0;
		obj_vspeed[0] = 0;
	
	}

}